/* ************************************************************************** */
/* Example of a syndication feed reader using the Project Rome API            */
/* current version of Rome: rome1.0.jar            https://rome.dev.java.net/ */
/* You need to implement this API plus the JDOM API                           */
/* jdom.jar  ,   you can find this at               https://jdom.org/         */
/* Parts of this example are taken from the PRome Web Page tutorials          */
/* https://rome.dev.java.net/ thanks to author:   Alejandro Abdelnur          */
/*                                                                            */
/* This program aggregates different syndication feeds from                   */
/* different web resources and joins them into one file.                      */
/* created by Martin Stoppacher       date:  26.12.2009                       */
/* license:    LGPL 3.0                                                       */
/*             (Lesser Gnu Public License version 3.0),                       */
/*             cf. <http://www.gnu.org/licenses/lgpl.html>                    */
/* ************************************************************************** */  
import java.net.URL;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.ArrayList;

import com.sun.syndication.feed.synd.SyndFeed;
/* This is the Bean interface for all types of feeds.                         */
import com.sun.syndication.feed.synd.SyndFeedImpl;
/* This is a Bean for all types of feeds                                      */
import com.sun.syndication.io.SyndFeedOutput;
/* Generates an XML document(String, File, OutputStream, Writer,              */
/* W3C DOM document or JDOM document)out of an SyndFeedImpl                   */
import com.sun.syndication.io.SyndFeedInput;
/* Parses an XML document (File, InputStream, Reader, W3C SAX InputSource, W3C*/
/* DOM Document or JDom DOcument) into an WireFeed (RSS/Atom).                */
import com.sun.syndication.io.XmlReader;
/* Character stream that handles (or at least attemtps to) all the necessary  */
/* Voodo to figure out the charset encoding of the XML document within        */
/* the stream.                                                                */

public class 6_FeedAggregator {

    public static void main(String[] args) {
        boolean ok = false;
        if (args.length>=2) {                    /* one or more feed adresses */
            try {
                String outputType = args[0]; 
                /*                        fist argument must be the feed type */
                String fileName = "test4_"+outputType;

                SyndFeed feed = new SyndFeedImpl(); 
                /*                              creates a new syndfeed object */
                feed.setFeedType(outputType); /* specifies which type of feed */

                feed.setTitle("Aggregated Feed"); /*specification of the feed */
                feed.setDescription("Anonymous Aggregated Feed");  /*  *****  */
                feed.setAuthor("Martin Stoppacher");               /*  *****  */
                feed.setLink("http://martinstoppacher.com");       /*  *****  */

                List entries = new ArrayList(); /* Creates an enties Object   */
                feed.setEntries(entries);  
                /*                   connects the entries Object to the feed  */

                for (int i=1;i<args.length;i++) { /* loop to insert all feeds */
                    URL inputUrl = new URL(args[i]);

                    SyndFeedInput input = new SyndFeedInput();
                    SyndFeed inFeed = input.build(new XmlReader(inputUrl));

                    entries.addAll(inFeed.getEntries()); 
                    /* add the entries of the fetched "infeed"                */
                    /* to the created feed                                    */

                }

                SyndFeedOutput output = new SyndFeedOutput();  
                output.output(feed,new PrintWriter(System.out)); 
                
                /*                                       // optional writer part
                Writer writer = new FileWriter(fileName);
                SyndFeedOutput output1 = new SyndFeedOutput();
                output1.output(feed,writer);
                writer.close();
                */

                ok = true;
            }
            catch (Exception ex) {
                System.out.println("ERROR: "+ex.getMessage());
            }
        }

        if (!ok) {
            System.out.println();
            System.out.println("FeedAggregator aggregates different feeds" 
                              +" into a single one.");
            System.out.println("The first parameter must be the feed type" 
                              +" for the aggregated feed.");
            System.out.println(" [valid values are: rss_0.9, rss_0.91U,"
                              +" rss_0.91N, rss_0.92, rss_0.93, ]");
            System.out.println(" [                  rss_0.94, rss_1.0," 
                              +" rss_2.0 & atom_0.3  ]");
            System.out.println("The second to last parameters are the" 
                              +" URLs of feeds to aggregate.");
            System.out.println();
        }
    }

}